﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Marquee Settings class - stores the configuration data about the marquee and marquee history.
    /// </summary>
    public class MarqueeSettings
    {
        public MarqueeSettings()
        {
            Items = new Dictionary<string, MarqueeItem>();
        }

        public string ActiveIndex { get; set; }
        public Dictionary<string, MarqueeItem> Items { get; set; }

        public string ActiveMarqueeText { get { return !String.IsNullOrEmpty(ActiveIndex) && Items.ContainsKey(ActiveIndex) ? Items[ActiveIndex].Text : String.Empty;  } }
    }

    public class MarqueeItem
    {
        public string Index { get; set; }
        public string Text { get; set; }
    }
}
